﻿//////////////////////////////////////////////
// NodeManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Node ;
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Node.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

// Standards
#include <mutex>
#include <unordered_map>
#include <string>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT NodeManager final : public Manager<Node>, public nkCommon::MaybeSingletonClass<NodeManager>
	{
		private :

			// Functions
			// Constructor
			NodeManager (bool isSingleton) noexcept ;
			NodeManager (System* system) noexcept ;

		private :

			friend class nkCommon::MaybeSingletonClass<NodeManager> ;
			friend class System ;
	} ;
}